from abc import ABC
import random
import json
import re


SEED = 42
random.seed(42)


DummyNumericColumn = [
    {
        "header": "Index",
        "sampleValues": [i for i in range(11)]
    },
    {
        "header": "Cost",
        "sampleValues": [100*i for i in range(11)]
    }
]


class ContextTree(ABC):

    def __init__(self, contextTree):
        self.tree = json.loads(contextTree)
    
    def GetTableNames(self):
        return [table["name"] for table in self.tree["activeTables"]]
    
    def GetColumnNames(self, tableName=None):
        if tableName:
            table = next(item for item in self.tree["activeTables"] if item["name"] == tableName)
            return table["headers"][0]
        return self.tree["activeTables"][0]["headers"][0]
    
    def AddDummyNumericColumn(self):
        NumericColumn = random.choice(DummyNumericColumn)
        currentTable = self.tree["activeTables"][0]
        currentTable["headers"][0].append(NumericColumn["header"])
        for index, row in enumerate(currentTable["firstRowValues"]):
            row.append(NumericColumn["sampleValues"][index])
        for index, row in enumerate(currentTable["lastRowValues"]):
            row.append(NumericColumn["sampleValues"][-index])
        currentTable["numberFormats"].append("Number")
    
    def getString(self):
        return json.dumps(self.tree)
    

def test():
    with open("SampleContextTree.json", "r") as f:
        data = f.read()
        context = ContextTree(data)
    print(context.GetTableNames())
    print(context.GetColumnNames())
    print(context.GetColumnNames("Budget"))
    context.AddDummyNumericColumn()
    print(context.GetColumnNames())


if __name__ == "__main__":
    test()